{
    "$graph": [
        {
            "class": "Workflow",
            "label": "Detect Variants workflow",
            "requirements": [
                {
                    "class": "SubworkflowFeatureRequirement"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "boolean"
                    ],
                    "id": "#main/annotate_coding_only"
                },
                {
                    "type": [
                        "null",
                        "boolean"
                    ],
                    "default": false,
                    "id": "#main/cle_vcf_filter"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/cosmic_vcf"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/custom_clinvar_vcf"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/custom_gnomad_vcf"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/dbsnp_vcf"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/docm_vcf"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.001,
                    "id": "#main/filter_gnomADe_maximum_population_allele_frequency"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.15,
                    "id": "#main/filter_mapq0_threshold"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 5,
                    "id": "#main/filter_somatic_llr_threshold"
                },
                {
                    "type": "File",
                    "id": "#main/interval_list"
                },
                {
                    "type": [
                        "null",
                        "boolean"
                    ],
                    "id": "#main/mutect_artifact_detection_mode"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#main/mutect_max_alt_allele_in_normal_fraction"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#main/mutect_max_alt_alleles_in_normal_count"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#main/mutect_scatter_count"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".bai",
                        "^.bai"
                    ],
                    "id": "#main/normal_bam"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/panel_of_normals_vcf"
                },
                {
                    "type": "int",
                    "default": 400,
                    "id": "#main/pindel_insert_size"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#main/readcount_minimum_base_quality"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#main/readcount_minimum_mapping_quality"
                },
                {
                    "type": "string",
                    "id": "#main/reference"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 8,
                    "id": "#main/strelka_cpu_reserved"
                },
                {
                    "type": "boolean",
                    "id": "#main/strelka_exome_mode"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#main/synonyms_file"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".bai",
                        "^.bai"
                    ],
                    "id": "#main/tumor_bam"
                },
                {
                    "type": [
                        "null",
                        {
                            "type": "array",
                            "items": "string"
                        }
                    ],
                    "default": [
                        "CHROM",
                        "POS",
                        "ID",
                        "REF",
                        "ALT",
                        "set",
                        "AC",
                        "AF"
                    ],
                    "id": "#main/variants_to_table_fields"
                },
                {
                    "type": [
                        "null",
                        {
                            "type": "array",
                            "items": "string"
                        }
                    ],
                    "default": [
                        "GT",
                        "AD"
                    ],
                    "id": "#main/variants_to_table_genotype_fields"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#main/varscan_max_normal_freq"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 8,
                    "id": "#main/varscan_min_coverage"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.1,
                    "id": "#main/varscan_min_var_freq"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.99,
                    "id": "#main/varscan_p_value"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 0,
                    "id": "#main/varscan_strand_filter"
                },
                {
                    "type": "string",
                    "id": "#main/vep_cache_dir"
                },
                {
                    "type": [
                        "null",
                        {
                            "type": "enum",
                            "symbols": [
                                "#main/vep_pick/pick",
                                "#main/vep_pick/flag_pick",
                                "#main/vep_pick/pick_allele",
                                "#main/vep_pick/per_gene",
                                "#main/vep_pick/pick_allele_gene",
                                "#main/vep_pick/flag_pick_allele",
                                "#main/vep_pick/flag_pick_allele_gene"
                            ]
                        }
                    ],
                    "id": "#main/vep_pick"
                },
                {
                    "type": [
                        "null",
                        {
                            "type": "array",
                            "items": "string"
                        }
                    ],
                    "default": [
                        "HGVSc",
                        "HGVSp"
                    ],
                    "id": "#main/vep_to_table_fields"
                }
            ],
            "steps": [
                {
                    "run": "#vcf_readcount_annotator.cwl",
                    "in": [
                        {
                            "default": "DNA",
                            "id": "#main/add_normal_bam_readcount_to_vcf/data_type"
                        },
                        {
                            "source": "#main/normal_bam_readcount/indel_bam_readcount_tsv",
                            "id": "#main/add_normal_bam_readcount_to_vcf/indel_bam_readcount_tsv"
                        },
                        {
                            "default": "NORMAL",
                            "id": "#main/add_normal_bam_readcount_to_vcf/sample_name"
                        },
                        {
                            "source": "#main/normal_bam_readcount/snv_bam_readcount_tsv",
                            "id": "#main/add_normal_bam_readcount_to_vcf/snv_bam_readcount_tsv"
                        },
                        {
                            "source": "#main/add_tumor_bam_readcount_to_vcf/annotated_bam_readcount_vcf",
                            "id": "#main/add_normal_bam_readcount_to_vcf/vcf"
                        }
                    ],
                    "out": [
                        "#main/add_normal_bam_readcount_to_vcf/annotated_bam_readcount_vcf"
                    ],
                    "id": "#main/add_normal_bam_readcount_to_vcf"
                },
                {
                    "run": "#vcf_readcount_annotator.cwl",
                    "in": [
                        {
                            "default": "DNA",
                            "id": "#main/add_tumor_bam_readcount_to_vcf/data_type"
                        },
                        {
                            "source": "#main/tumor_bam_readcount/indel_bam_readcount_tsv",
                            "id": "#main/add_tumor_bam_readcount_to_vcf/indel_bam_readcount_tsv"
                        },
                        {
                            "default": "TUMOR",
                            "id": "#main/add_tumor_bam_readcount_to_vcf/sample_name"
                        },
                        {
                            "source": "#main/tumor_bam_readcount/snv_bam_readcount_tsv",
                            "id": "#main/add_tumor_bam_readcount_to_vcf/snv_bam_readcount_tsv"
                        },
                        {
                            "source": "#main/annotate_variants/annotated_vcf",
                            "id": "#main/add_tumor_bam_readcount_to_vcf/vcf"
                        }
                    ],
                    "out": [
                        "#main/add_tumor_bam_readcount_to_vcf/annotated_bam_readcount_vcf"
                    ],
                    "id": "#main/add_tumor_bam_readcount_to_vcf"
                },
                {
                    "run": "#add_vep_fields_to_table.cwl",
                    "in": [
                        {
                            "source": "#main/variants_to_table/variants_tsv",
                            "id": "#main/add_vep_fields_to_table/tsv"
                        },
                        {
                            "source": "#main/annotated_filter_index/indexed_vcf",
                            "id": "#main/add_vep_fields_to_table/vcf"
                        },
                        {
                            "source": "#main/vep_to_table_fields",
                            "id": "#main/add_vep_fields_to_table/vep_fields"
                        }
                    ],
                    "out": [
                        "#main/add_vep_fields_to_table/annotated_variants_tsv"
                    ],
                    "id": "#main/add_vep_fields_to_table"
                },
                {
                    "run": "#vep.cwl",
                    "in": [
                        {
                            "source": "#main/vep_cache_dir",
                            "id": "#main/annotate_variants/cache_dir"
                        },
                        {
                            "source": "#main/annotate_coding_only",
                            "id": "#main/annotate_variants/coding_only"
                        },
                        {
                            "source": "#main/custom_clinvar_vcf",
                            "id": "#main/annotate_variants/custom_clivnar_vcf"
                        },
                        {
                            "source": "#main/custom_gnomad_vcf",
                            "id": "#main/annotate_variants/custom_gnomad_vcf"
                        },
                        {
                            "source": "#main/vep_pick",
                            "id": "#main/annotate_variants/pick"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/annotate_variants/reference"
                        },
                        {
                            "source": "#main/synonyms_file",
                            "id": "#main/annotate_variants/synonyms_file"
                        },
                        {
                            "source": "#main/decompose/decomposed_vcf",
                            "id": "#main/annotate_variants/vcf"
                        }
                    ],
                    "out": [
                        "#main/annotate_variants/annotated_vcf",
                        "#main/annotate_variants/vep_summary"
                    ],
                    "id": "#main/annotate_variants"
                },
                {
                    "run": "#bgzip.cwl",
                    "in": [
                        {
                            "source": "#main/filter_vcf/filtered_vcf",
                            "id": "#main/annotated_filter_bgzip/file"
                        }
                    ],
                    "out": [
                        "#main/annotated_filter_bgzip/bgzipped_file"
                    ],
                    "id": "#main/annotated_filter_bgzip"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#main/annotated_filter_bgzip/bgzipped_file",
                            "id": "#main/annotated_filter_index/vcf"
                        }
                    ],
                    "out": [
                        "#main/annotated_filter_index/indexed_vcf"
                    ],
                    "id": "#main/annotated_filter_index"
                },
                {
                    "run": "#combine_variants.cwl",
                    "in": [
                        {
                            "source": "#main/docm/filtered_vcf",
                            "id": "#main/combine/docm_vcf"
                        },
                        {
                            "source": "#main/mutect/filtered_vcf",
                            "id": "#main/combine/mutect_vcf"
                        },
                        {
                            "source": "#main/pindel/filtered_vcf",
                            "id": "#main/combine/pindel_vcf"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/combine/reference"
                        },
                        {
                            "source": "#main/strelka/filtered_vcf",
                            "id": "#main/combine/strelka_vcf"
                        },
                        {
                            "source": "#main/varscan/filtered_vcf",
                            "id": "#main/combine/varscan_vcf"
                        }
                    ],
                    "out": [
                        "#main/combine/combined_vcf"
                    ],
                    "id": "#main/combine"
                },
                {
                    "run": "#vt_decompose.cwl",
                    "in": [
                        {
                            "source": "#main/combine/combined_vcf",
                            "id": "#main/decompose/vcf"
                        }
                    ],
                    "out": [
                        "#main/decompose/decomposed_vcf"
                    ],
                    "id": "#main/decompose"
                },
                {
                    "run": "#docm_cle.cwl",
                    "in": [
                        {
                            "source": "#main/docm_vcf",
                            "id": "#main/docm/docm_vcf"
                        },
                        {
                            "source": "#main/interval_list",
                            "id": "#main/docm/interval_list"
                        },
                        {
                            "source": "#main/normal_bam",
                            "id": "#main/docm/normal_bam"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/docm/reference"
                        },
                        {
                            "source": "#main/tumor_bam",
                            "id": "#main/docm/tumor_bam"
                        }
                    ],
                    "out": [
                        "#main/docm/unfiltered_vcf",
                        "#main/docm/filtered_vcf"
                    ],
                    "id": "#main/docm"
                },
                {
                    "run": "#filter_vcf.cwl",
                    "in": [
                        {
                            "source": "#main/cle_vcf_filter",
                            "id": "#main/filter_vcf/do_cle_vcf_filter"
                        },
                        {
                            "source": "#main/filter_gnomADe_maximum_population_allele_frequency",
                            "id": "#main/filter_vcf/filter_gnomADe_maximum_population_allele_frequency"
                        },
                        {
                            "source": "#main/filter_mapq0_threshold",
                            "id": "#main/filter_vcf/filter_mapq0_threshold"
                        },
                        {
                            "source": "#main/filter_somatic_llr_threshold",
                            "id": "#main/filter_vcf/filter_somatic_llr_threshold"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/filter_vcf/reference"
                        },
                        {
                            "source": "#main/tumor_bam",
                            "id": "#main/filter_vcf/tumor_bam"
                        },
                        {
                            "source": "#main/index/indexed_vcf",
                            "id": "#main/filter_vcf/vcf"
                        }
                    ],
                    "out": [
                        "#main/filter_vcf/filtered_vcf"
                    ],
                    "id": "#main/filter_vcf"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#main/add_normal_bam_readcount_to_vcf/annotated_bam_readcount_vcf",
                            "id": "#main/index/vcf"
                        }
                    ],
                    "out": [
                        "#main/index/indexed_vcf"
                    ],
                    "id": "#main/index"
                },
                {
                    "run": "#mutect.cwl",
                    "in": [
                        {
                            "source": "#main/mutect_artifact_detection_mode",
                            "id": "#main/mutect/artifact_detection_mode"
                        },
                        {
                            "source": "#main/cosmic_vcf",
                            "id": "#main/mutect/cosmic_vcf"
                        },
                        {
                            "source": "#main/dbsnp_vcf",
                            "id": "#main/mutect/dbsnp_vcf"
                        },
                        {
                            "source": "#main/interval_list",
                            "id": "#main/mutect/interval_list"
                        },
                        {
                            "source": "#main/mutect_max_alt_allele_in_normal_fraction",
                            "id": "#main/mutect/max_alt_allele_in_normal_fraction"
                        },
                        {
                            "source": "#main/mutect_max_alt_alleles_in_normal_count",
                            "id": "#main/mutect/max_alt_alleles_in_normal_count"
                        },
                        {
                            "source": "#main/normal_bam",
                            "id": "#main/mutect/normal_bam"
                        },
                        {
                            "source": "#main/panel_of_normals_vcf",
                            "id": "#main/mutect/panel_of_normals_vcf"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/mutect/reference"
                        },
                        {
                            "source": "#main/mutect_scatter_count",
                            "id": "#main/mutect/scatter_count"
                        },
                        {
                            "source": "#main/tumor_bam",
                            "id": "#main/mutect/tumor_bam"
                        }
                    ],
                    "out": [
                        "#main/mutect/unfiltered_vcf",
                        "#main/mutect/filtered_vcf"
                    ],
                    "id": "#main/mutect"
                },
                {
                    "run": "#bam_readcount.cwl",
                    "in": [
                        {
                            "source": "#main/normal_bam",
                            "id": "#main/normal_bam_readcount/bam"
                        },
                        {
                            "source": "#main/readcount_minimum_base_quality",
                            "id": "#main/normal_bam_readcount/min_base_quality"
                        },
                        {
                            "source": "#main/readcount_minimum_mapping_quality",
                            "id": "#main/normal_bam_readcount/min_mapping_quality"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/normal_bam_readcount/reference_fasta"
                        },
                        {
                            "default": "NORMAL",
                            "id": "#main/normal_bam_readcount/sample"
                        },
                        {
                            "source": "#main/annotate_variants/annotated_vcf",
                            "id": "#main/normal_bam_readcount/vcf"
                        }
                    ],
                    "out": [
                        "#main/normal_bam_readcount/snv_bam_readcount_tsv",
                        "#main/normal_bam_readcount/indel_bam_readcount_tsv"
                    ],
                    "id": "#main/normal_bam_readcount"
                },
                {
                    "run": "#pindel.cwl",
                    "in": [
                        {
                            "source": "#main/pindel_insert_size",
                            "id": "#main/pindel/insert_size"
                        },
                        {
                            "source": "#main/interval_list",
                            "id": "#main/pindel/interval_list"
                        },
                        {
                            "source": "#main/normal_bam",
                            "id": "#main/pindel/normal_bam"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/pindel/reference"
                        },
                        {
                            "source": "#main/tumor_bam",
                            "id": "#main/pindel/tumor_bam"
                        }
                    ],
                    "out": [
                        "#main/pindel/unfiltered_vcf",
                        "#main/pindel/filtered_vcf"
                    ],
                    "id": "#main/pindel"
                },
                {
                    "run": "#strelka_and_post_processing.cwl",
                    "in": [
                        {
                            "source": "#main/strelka_cpu_reserved",
                            "id": "#main/strelka/cpu_reserved"
                        },
                        {
                            "source": "#main/strelka_exome_mode",
                            "id": "#main/strelka/exome_mode"
                        },
                        {
                            "source": "#main/interval_list",
                            "id": "#main/strelka/interval_list"
                        },
                        {
                            "source": "#main/normal_bam",
                            "id": "#main/strelka/normal_bam"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/strelka/reference"
                        },
                        {
                            "source": "#main/tumor_bam",
                            "id": "#main/strelka/tumor_bam"
                        }
                    ],
                    "out": [
                        "#main/strelka/unfiltered_vcf",
                        "#main/strelka/filtered_vcf"
                    ],
                    "id": "#main/strelka"
                },
                {
                    "run": "#bam_readcount.cwl",
                    "in": [
                        {
                            "source": "#main/tumor_bam",
                            "id": "#main/tumor_bam_readcount/bam"
                        },
                        {
                            "source": "#main/readcount_minimum_base_quality",
                            "id": "#main/tumor_bam_readcount/min_base_quality"
                        },
                        {
                            "source": "#main/readcount_minimum_mapping_quality",
                            "id": "#main/tumor_bam_readcount/min_mapping_quality"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/tumor_bam_readcount/reference_fasta"
                        },
                        {
                            "default": "TUMOR",
                            "id": "#main/tumor_bam_readcount/sample"
                        },
                        {
                            "source": "#main/annotate_variants/annotated_vcf",
                            "id": "#main/tumor_bam_readcount/vcf"
                        }
                    ],
                    "out": [
                        "#main/tumor_bam_readcount/snv_bam_readcount_tsv",
                        "#main/tumor_bam_readcount/indel_bam_readcount_tsv"
                    ],
                    "id": "#main/tumor_bam_readcount"
                },
                {
                    "run": "#variants_to_table.cwl",
                    "in": [
                        {
                            "source": "#main/variants_to_table_fields",
                            "id": "#main/variants_to_table/fields"
                        },
                        {
                            "source": "#main/variants_to_table_genotype_fields",
                            "id": "#main/variants_to_table/genotype_fields"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/variants_to_table/reference"
                        },
                        {
                            "source": "#main/annotated_filter_index/indexed_vcf",
                            "id": "#main/variants_to_table/vcf"
                        }
                    ],
                    "out": [
                        "#main/variants_to_table/variants_tsv"
                    ],
                    "id": "#main/variants_to_table"
                },
                {
                    "run": "#varscan_pre_and_post_processing.cwl",
                    "in": [
                        {
                            "source": "#main/interval_list",
                            "id": "#main/varscan/interval_list"
                        },
                        {
                            "source": "#main/varscan_max_normal_freq",
                            "id": "#main/varscan/max_normal_freq"
                        },
                        {
                            "source": "#main/varscan_min_coverage",
                            "id": "#main/varscan/min_coverage"
                        },
                        {
                            "source": "#main/varscan_min_var_freq",
                            "id": "#main/varscan/min_var_freq"
                        },
                        {
                            "source": "#main/normal_bam",
                            "id": "#main/varscan/normal_bam"
                        },
                        {
                            "source": "#main/varscan_p_value",
                            "id": "#main/varscan/p_value"
                        },
                        {
                            "source": "#main/reference",
                            "id": "#main/varscan/reference"
                        },
                        {
                            "source": "#main/varscan_strand_filter",
                            "id": "#main/varscan/strand_filter"
                        },
                        {
                            "source": "#main/tumor_bam",
                            "id": "#main/varscan/tumor_bam"
                        }
                    ],
                    "out": [
                        "#main/varscan/unfiltered_vcf",
                        "#main/varscan/filtered_vcf"
                    ],
                    "id": "#main/varscan"
                }
            ],
            "id": "#main",
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#main/docm/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/docm_filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/docm/unfiltered_vcf",
                    "id": "#main/docm_unfiltered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/annotated_filter_index/indexed_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/final_filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/add_vep_fields_to_table/annotated_variants_tsv",
                    "id": "#main/final_tsv"
                },
                {
                    "type": "File",
                    "outputSource": "#main/index/indexed_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/final_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/mutect/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/mutect_filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/mutect/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/mutect_unfiltered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/normal_bam_readcount/indel_bam_readcount_tsv",
                    "id": "#main/normal_indel_bam_readcount_tsv"
                },
                {
                    "type": "File",
                    "outputSource": "#main/normal_bam_readcount/snv_bam_readcount_tsv",
                    "id": "#main/normal_snv_bam_readcount_tsv"
                },
                {
                    "type": "File",
                    "outputSource": "#main/pindel/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/pindel_filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/pindel/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/pindel_unfiltered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/strelka/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/strelka_filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/strelka/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/strelka_unfiltered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/tumor_bam_readcount/indel_bam_readcount_tsv",
                    "id": "#main/tumor_indel_bam_readcount_tsv"
                },
                {
                    "type": "File",
                    "outputSource": "#main/tumor_bam_readcount/snv_bam_readcount_tsv",
                    "id": "#main/tumor_snv_bam_readcount_tsv"
                },
                {
                    "type": "File",
                    "outputSource": "#main/varscan/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/varscan_filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/varscan/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#main/varscan_unfiltered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#main/annotate_variants/vep_summary",
                    "id": "#main/vep_summary"
                }
            ]
        },
        {
            "class": "Workflow",
            "label": "bgzip and index VCF",
            "inputs": [
                {
                    "type": "File",
                    "id": "#bgzip_and_index.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#bgzip_and_index.cwl/index/indexed_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#bgzip_and_index.cwl/indexed_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#bgzip.cwl",
                    "in": [
                        {
                            "source": "#bgzip_and_index.cwl/vcf",
                            "id": "#bgzip_and_index.cwl/bgzip/file"
                        }
                    ],
                    "out": [
                        "#bgzip_and_index.cwl/bgzip/bgzipped_file"
                    ],
                    "id": "#bgzip_and_index.cwl/bgzip"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#bgzip_and_index.cwl/bgzip/bgzipped_file",
                            "id": "#bgzip_and_index.cwl/index/vcf"
                        }
                    ],
                    "out": [
                        "#bgzip_and_index.cwl/index/indexed_vcf"
                    ],
                    "id": "#bgzip_and_index.cwl/index"
                }
            ],
            "id": "#bgzip_and_index.cwl"
        },
        {
            "class": "Workflow",
            "label": "Detect Docm variants",
            "requirements": [
                {
                    "class": "SubworkflowFeatureRequirement"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#docm_cle.cwl/docm_vcf"
                },
                {
                    "type": "File",
                    "id": "#docm_cle.cwl/interval_list"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#docm_cle.cwl/normal_bam"
                },
                {
                    "type": "string",
                    "id": "#docm_cle.cwl/reference"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#docm_cle.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#docm_cle.cwl/index/indexed_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#docm_cle.cwl/filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#docm_cle.cwl/GATK_haplotype_caller/docm_out",
                    "id": "#docm_cle.cwl/unfiltered_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#docm_gatk_haplotype_caller.cwl",
                    "in": [
                        {
                            "source": "#docm_cle.cwl/tumor_bam",
                            "id": "#docm_cle.cwl/GATK_haplotype_caller/bam"
                        },
                        {
                            "source": "#docm_cle.cwl/docm_vcf",
                            "id": "#docm_cle.cwl/GATK_haplotype_caller/docm_vcf"
                        },
                        {
                            "source": "#docm_cle.cwl/interval_list",
                            "id": "#docm_cle.cwl/GATK_haplotype_caller/interval_list"
                        },
                        {
                            "source": "#docm_cle.cwl/normal_bam",
                            "id": "#docm_cle.cwl/GATK_haplotype_caller/normal_bam"
                        },
                        {
                            "source": "#docm_cle.cwl/reference",
                            "id": "#docm_cle.cwl/GATK_haplotype_caller/reference"
                        }
                    ],
                    "out": [
                        "#docm_cle.cwl/GATK_haplotype_caller/docm_out"
                    ],
                    "id": "#docm_cle.cwl/GATK_haplotype_caller"
                },
                {
                    "run": "#bgzip.cwl",
                    "in": [
                        {
                            "source": "#docm_cle.cwl/docm_filter/docm_filter_out",
                            "id": "#docm_cle.cwl/bgzip/file"
                        }
                    ],
                    "out": [
                        "#docm_cle.cwl/bgzip/bgzipped_file"
                    ],
                    "id": "#docm_cle.cwl/bgzip"
                },
                {
                    "run": "#somatic_docm_filter.cwl",
                    "in": [
                        {
                            "source": "#docm_cle.cwl/GATK_haplotype_caller/docm_out",
                            "id": "#docm_cle.cwl/docm_filter/docm_out"
                        },
                        {
                            "source": "#docm_cle.cwl/normal_bam",
                            "id": "#docm_cle.cwl/docm_filter/normal_bam"
                        },
                        {
                            "source": "#docm_cle.cwl/tumor_bam",
                            "id": "#docm_cle.cwl/docm_filter/tumor_bam"
                        }
                    ],
                    "out": [
                        "#docm_cle.cwl/docm_filter/docm_filter_out"
                    ],
                    "id": "#docm_cle.cwl/docm_filter"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#docm_cle.cwl/bgzip/bgzipped_file",
                            "id": "#docm_cle.cwl/index/vcf"
                        }
                    ],
                    "out": [
                        "#docm_cle.cwl/index/indexed_vcf"
                    ],
                    "id": "#docm_cle.cwl/index"
                }
            ],
            "id": "#docm_cle.cwl"
        },
        {
            "class": "Workflow",
            "label": "Apply filters to VCF file",
            "requirements": [
                {
                    "class": "SubworkflowFeatureRequirement"
                }
            ],
            "inputs": [
                {
                    "type": "boolean",
                    "id": "#filter_vcf.cwl/do_cle_vcf_filter"
                },
                {
                    "type": "float",
                    "id": "#filter_vcf.cwl/filter_gnomADe_maximum_population_allele_frequency"
                },
                {
                    "type": "float",
                    "id": "#filter_vcf.cwl/filter_mapq0_threshold"
                },
                {
                    "type": "float",
                    "id": "#filter_vcf.cwl/filter_somatic_llr_threshold"
                },
                {
                    "type": "string",
                    "id": "#filter_vcf.cwl/reference"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".bai"
                    ],
                    "id": "#filter_vcf.cwl/tumor_bam"
                },
                {
                    "type": "File",
                    "id": "#filter_vcf.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#filter_vcf.cwl/filter_vcf_cle/cle_filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#filter_vcf.cwl/filtered_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#filter_vcf_cle.cwl",
                    "in": [
                        {
                            "source": "#filter_vcf.cwl/do_cle_vcf_filter",
                            "id": "#filter_vcf.cwl/filter_vcf_cle/filter"
                        },
                        {
                            "source": "#filter_vcf.cwl/filter_vcf_mapq0/mapq0_filtered_vcf",
                            "id": "#filter_vcf.cwl/filter_vcf_cle/vcf"
                        }
                    ],
                    "out": [
                        "#filter_vcf.cwl/filter_vcf_cle/cle_filtered_vcf"
                    ],
                    "id": "#filter_vcf.cwl/filter_vcf_cle"
                },
                {
                    "run": "#filter_vcf_gnomADe_allele_freq.cwl",
                    "in": [
                        {
                            "source": "#filter_vcf.cwl/filter_gnomADe_maximum_population_allele_frequency",
                            "id": "#filter_vcf.cwl/filter_vcf_gnomADe_allele_freq/maximum_population_allele_frequency"
                        },
                        {
                            "source": "#filter_vcf.cwl/vcf",
                            "id": "#filter_vcf.cwl/filter_vcf_gnomADe_allele_freq/vcf"
                        }
                    ],
                    "out": [
                        "#filter_vcf.cwl/filter_vcf_gnomADe_allele_freq/filtered_vcf"
                    ],
                    "id": "#filter_vcf.cwl/filter_vcf_gnomADe_allele_freq"
                },
                {
                    "run": "#filter_vcf_mapq0.cwl",
                    "in": [
                        {
                            "source": "#filter_vcf.cwl/reference",
                            "id": "#filter_vcf.cwl/filter_vcf_mapq0/reference"
                        },
                        {
                            "source": "#filter_vcf.cwl/filter_mapq0_threshold",
                            "id": "#filter_vcf.cwl/filter_vcf_mapq0/threshold"
                        },
                        {
                            "source": "#filter_vcf.cwl/tumor_bam",
                            "id": "#filter_vcf.cwl/filter_vcf_mapq0/tumor_bam"
                        },
                        {
                            "source": "#filter_vcf.cwl/filter_vcf_gnomADe_allele_freq/filtered_vcf",
                            "id": "#filter_vcf.cwl/filter_vcf_mapq0/vcf"
                        }
                    ],
                    "out": [
                        "#filter_vcf.cwl/filter_vcf_mapq0/mapq0_filtered_vcf"
                    ],
                    "id": "#filter_vcf.cwl/filter_vcf_mapq0"
                },
                {
                    "run": "#filter_vcf_somatic_llr.cwl",
                    "in": [
                        {
                            "source": "#filter_vcf.cwl/filter_somatic_llr_threshold",
                            "id": "#filter_vcf.cwl/filter_vcf_somatic_llr/threshold"
                        },
                        {
                            "source": "#filter_vcf.cwl/filter_vcf_cle/cle_filtered_vcf",
                            "id": "#filter_vcf.cwl/filter_vcf_somatic_llr/vcf"
                        }
                    ],
                    "out": [
                        "#filter_vcf.cwl/filter_vcf_somatic_llr/somatic_llr_filtered_vcf"
                    ],
                    "id": "#filter_vcf.cwl/filter_vcf_somatic_llr"
                }
            ],
            "id": "#filter_vcf.cwl"
        },
        {
            "class": "Workflow",
            "label": "fp_filter workflow",
            "requirements": [
                {
                    "class": "SubworkflowFeatureRequirement"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".bai",
                        "^.bai"
                    ],
                    "id": "#fp_filter.cwl/bam"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#fp_filter.cwl/min_var_freq"
                },
                {
                    "type": "string",
                    "id": "#fp_filter.cwl/reference"
                },
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "id": "#fp_filter.cwl/sample_name"
                },
                {
                    "type": "string",
                    "id": "#fp_filter.cwl/variant_caller"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#fp_filter.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#fp_filter.cwl/hard_filter/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#fp_filter.cwl/filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#fp_filter.cwl/fp_index/indexed_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#fp_filter.cwl/unfiltered_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#vt_decompose.cwl",
                    "in": [
                        {
                            "source": "#fp_filter.cwl/normalize_variants/normalized_vcf",
                            "id": "#fp_filter.cwl/decompose_variants/vcf"
                        }
                    ],
                    "out": [
                        "#fp_filter.cwl/decompose_variants/decomposed_vcf"
                    ],
                    "id": "#fp_filter.cwl/decompose_variants"
                },
                {
                    "run": "#bgzip.cwl",
                    "in": [
                        {
                            "source": "#fp_filter.cwl/fp_filter/filtered_vcf",
                            "id": "#fp_filter.cwl/fp_bgzip/file"
                        }
                    ],
                    "out": [
                        "#fp_filter.cwl/fp_bgzip/bgzipped_file"
                    ],
                    "id": "#fp_filter.cwl/fp_bgzip"
                },
                {
                    "run": "#fp_filter.cwl_2",
                    "in": [
                        {
                            "source": "#fp_filter.cwl/bam",
                            "id": "#fp_filter.cwl/fp_filter/bam"
                        },
                        {
                            "source": "#fp_filter.cwl/min_var_freq",
                            "id": "#fp_filter.cwl/fp_filter/min_var_freq"
                        },
                        {
                            "source": "#fp_filter.cwl/variant_caller",
                            "valueFrom": "$(self)_full",
                            "id": "#fp_filter.cwl/fp_filter/output_vcf_basename"
                        },
                        {
                            "source": "#fp_filter.cwl/reference",
                            "id": "#fp_filter.cwl/fp_filter/reference"
                        },
                        {
                            "source": "#fp_filter.cwl/sample_name",
                            "id": "#fp_filter.cwl/fp_filter/sample_name"
                        },
                        {
                            "source": "#fp_filter.cwl/index/indexed_vcf",
                            "id": "#fp_filter.cwl/fp_filter/vcf"
                        }
                    ],
                    "out": [
                        "#fp_filter.cwl/fp_filter/filtered_vcf"
                    ],
                    "id": "#fp_filter.cwl/fp_filter"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#fp_filter.cwl/fp_bgzip/bgzipped_file",
                            "id": "#fp_filter.cwl/fp_index/vcf"
                        }
                    ],
                    "out": [
                        "#fp_filter.cwl/fp_index/indexed_vcf"
                    ],
                    "id": "#fp_filter.cwl/fp_index"
                },
                {
                    "run": "#select_variants.cwl",
                    "in": [
                        {
                            "default": true,
                            "id": "#fp_filter.cwl/hard_filter/exclude_filtered"
                        },
                        {
                            "source": "#fp_filter.cwl/variant_caller",
                            "valueFrom": "$(self)_filtered",
                            "id": "#fp_filter.cwl/hard_filter/output_vcf_basename"
                        },
                        {
                            "source": "#fp_filter.cwl/reference",
                            "id": "#fp_filter.cwl/hard_filter/reference"
                        },
                        {
                            "source": "#fp_filter.cwl/fp_index/indexed_vcf",
                            "id": "#fp_filter.cwl/hard_filter/vcf"
                        }
                    ],
                    "out": [
                        "#fp_filter.cwl/hard_filter/filtered_vcf"
                    ],
                    "id": "#fp_filter.cwl/hard_filter"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#fp_filter.cwl/decompose_variants/decomposed_vcf",
                            "id": "#fp_filter.cwl/index/vcf"
                        }
                    ],
                    "out": [
                        "#fp_filter.cwl/index/indexed_vcf"
                    ],
                    "id": "#fp_filter.cwl/index"
                },
                {
                    "run": "#normalize_variants.cwl",
                    "in": [
                        {
                            "source": "#fp_filter.cwl/reference",
                            "id": "#fp_filter.cwl/normalize_variants/reference"
                        },
                        {
                            "source": "#fp_filter.cwl/vcf",
                            "id": "#fp_filter.cwl/normalize_variants/vcf"
                        }
                    ],
                    "out": [
                        "#fp_filter.cwl/normalize_variants/normalized_vcf"
                    ],
                    "id": "#fp_filter.cwl/normalize_variants"
                }
            ],
            "id": "#fp_filter.cwl"
        },
        {
            "class": "Workflow",
            "label": "mutect parallel workflow",
            "requirements": [
                {
                    "class": "ScatterFeatureRequirement"
                },
                {
                    "class": "MultipleInputFeatureRequirement"
                },
                {
                    "class": "SubworkflowFeatureRequirement"
                },
                {
                    "class": "StepInputExpressionRequirement"
                }
            ],
            "inputs": [
                {
                    "type": "boolean",
                    "id": "#mutect.cwl/artifact_detection_mode"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl/cosmic_vcf"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl/dbsnp_vcf"
                },
                {
                    "type": "File",
                    "id": "#mutect.cwl/interval_list"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#mutect.cwl/max_alt_allele_in_normal_fraction"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#mutect.cwl/max_alt_alleles_in_normal_count"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".bai"
                    ],
                    "id": "#mutect.cwl/normal_bam"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl/panel_of_normals_vcf"
                },
                {
                    "type": "string",
                    "id": "#mutect.cwl/reference"
                },
                {
                    "type": "int",
                    "id": "#mutect.cwl/scatter_count"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".bai"
                    ],
                    "id": "#mutect.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#mutect.cwl/filter/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl/filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#mutect.cwl/filter/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl/unfiltered_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#fp_filter.cwl",
                    "in": [
                        {
                            "source": "#mutect.cwl/tumor_bam",
                            "id": "#mutect.cwl/filter/bam"
                        },
                        {
                            "source": "#mutect.cwl/reference",
                            "id": "#mutect.cwl/filter/reference"
                        },
                        {
                            "valueFrom": "mutect",
                            "id": "#mutect.cwl/filter/variant_caller"
                        },
                        {
                            "source": "#mutect.cwl/index/indexed_vcf",
                            "id": "#mutect.cwl/filter/vcf"
                        }
                    ],
                    "out": [
                        "#mutect.cwl/filter/unfiltered_vcf",
                        "#mutect.cwl/filter/filtered_vcf"
                    ],
                    "id": "#mutect.cwl/filter"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#mutect.cwl/merge/merged_vcf",
                            "id": "#mutect.cwl/index/vcf"
                        }
                    ],
                    "out": [
                        "#mutect.cwl/index/indexed_vcf"
                    ],
                    "id": "#mutect.cwl/index"
                },
                {
                    "run": "#merge_vcf.cwl",
                    "in": [
                        {
                            "source": "#mutect.cwl/mutect/vcf",
                            "id": "#mutect.cwl/merge/vcfs"
                        }
                    ],
                    "out": [
                        "#mutect.cwl/merge/merged_vcf"
                    ],
                    "id": "#mutect.cwl/merge"
                },
                {
                    "scatter": "#mutect.cwl/mutect/interval_list",
                    "run": "#mutect.cwl_2",
                    "in": [
                        {
                            "source": "#mutect.cwl/artifact_detection_mode",
                            "id": "#mutect.cwl/mutect/artifact_detection_mode"
                        },
                        {
                            "source": "#mutect.cwl/cosmic_vcf",
                            "id": "#mutect.cwl/mutect/cosmic_vcf"
                        },
                        {
                            "source": "#mutect.cwl/dbsnp_vcf",
                            "id": "#mutect.cwl/mutect/dbsnp_vcf"
                        },
                        {
                            "source": "#mutect.cwl/split_interval_list/split_interval_lists",
                            "id": "#mutect.cwl/mutect/interval_list"
                        },
                        {
                            "source": "#mutect.cwl/max_alt_allele_in_normal_fraction",
                            "id": "#mutect.cwl/mutect/max_alt_allele_in_normal_fraction"
                        },
                        {
                            "source": "#mutect.cwl/max_alt_alleles_in_normal_count",
                            "id": "#mutect.cwl/mutect/max_alt_alleles_in_normal_count"
                        },
                        {
                            "source": "#mutect.cwl/normal_bam",
                            "id": "#mutect.cwl/mutect/normal_bam"
                        },
                        {
                            "source": "#mutect.cwl/panel_of_normals_vcf",
                            "id": "#mutect.cwl/mutect/panel_of_normals_vcf"
                        },
                        {
                            "source": "#mutect.cwl/reference",
                            "id": "#mutect.cwl/mutect/reference"
                        },
                        {
                            "source": "#mutect.cwl/tumor_bam",
                            "id": "#mutect.cwl/mutect/tumor_bam"
                        }
                    ],
                    "out": [
                        "#mutect.cwl/mutect/vcf"
                    ],
                    "id": "#mutect.cwl/mutect"
                },
                {
                    "run": "#split_interval_list.cwl",
                    "in": [
                        {
                            "source": "#mutect.cwl/interval_list",
                            "id": "#mutect.cwl/split_interval_list/interval_list"
                        },
                        {
                            "source": "#mutect.cwl/scatter_count",
                            "id": "#mutect.cwl/split_interval_list/scatter_count"
                        }
                    ],
                    "out": [
                        "#mutect.cwl/split_interval_list/split_interval_lists"
                    ],
                    "id": "#mutect.cwl/split_interval_list"
                }
            ],
            "id": "#mutect.cwl"
        },
        {
            "class": "Workflow",
            "label": "pindel parallel workflow",
            "requirements": [
                {
                    "class": "ScatterFeatureRequirement"
                },
                {
                    "class": "MultipleInputFeatureRequirement"
                },
                {
                    "class": "SubworkflowFeatureRequirement"
                },
                {
                    "class": "StepInputExpressionRequirement"
                }
            ],
            "inputs": [
                {
                    "type": "int",
                    "default": 400,
                    "id": "#pindel.cwl/insert_size"
                },
                {
                    "type": "File",
                    "id": "#pindel.cwl/interval_list"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#pindel.cwl/normal_bam"
                },
                {
                    "type": "string",
                    "id": "#pindel.cwl/reference"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#pindel.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#pindel.cwl/filter/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#pindel.cwl/filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#pindel.cwl/filter/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#pindel.cwl/unfiltered_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#bgzip.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/somaticfilter/vcf",
                            "id": "#pindel.cwl/bgzip/file"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/bgzip/bgzipped_file"
                    ],
                    "id": "#pindel.cwl/bgzip"
                },
                {
                    "run": "#cat_all.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/pindel_cat/per_chromosome_pindel_out",
                            "id": "#pindel.cwl/cat_all/chromosome_pindel_outs"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/cat_all/all_chromosome_pindel_head"
                    ],
                    "id": "#pindel.cwl/cat_all"
                },
                {
                    "run": "#fp_filter.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/tumor_bam",
                            "id": "#pindel.cwl/filter/bam"
                        },
                        {
                            "source": "#pindel.cwl/reference",
                            "id": "#pindel.cwl/filter/reference"
                        },
                        {
                            "valueFrom": "pindel",
                            "id": "#pindel.cwl/filter/variant_caller"
                        },
                        {
                            "source": "#pindel.cwl/reindex/indexed_vcf",
                            "id": "#pindel.cwl/filter/vcf"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/filter/unfiltered_vcf",
                        "#pindel.cwl/filter/filtered_vcf"
                    ],
                    "id": "#pindel.cwl/filter"
                },
                {
                    "run": "#get_chromosome_list.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/interval_list",
                            "id": "#pindel.cwl/get_chromosome_list/interval_list"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/get_chromosome_list/chromosome_list"
                    ],
                    "id": "#pindel.cwl/get_chromosome_list"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/bgzip/bgzipped_file",
                            "id": "#pindel.cwl/index/vcf"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/index/indexed_vcf"
                    ],
                    "id": "#pindel.cwl/index"
                },
                {
                    "scatter": "#pindel.cwl/pindel_cat/chromosome",
                    "run": "#pindel_cat.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/get_chromosome_list/chromosome_list",
                            "id": "#pindel.cwl/pindel_cat/chromosome"
                        },
                        {
                            "source": "#pindel.cwl/insert_size",
                            "id": "#pindel.cwl/pindel_cat/insert_size"
                        },
                        {
                            "source": "#pindel.cwl/normal_bam",
                            "id": "#pindel.cwl/pindel_cat/normal_bam"
                        },
                        {
                            "source": "#pindel.cwl/reference",
                            "id": "#pindel.cwl/pindel_cat/reference"
                        },
                        {
                            "source": "#pindel.cwl/tumor_bam",
                            "id": "#pindel.cwl/pindel_cat/tumor_bam"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/pindel_cat/per_chromosome_pindel_out"
                    ],
                    "id": "#pindel.cwl/pindel_cat"
                },
                {
                    "run": "#select_variants.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/interval_list",
                            "id": "#pindel.cwl/region_filter/interval_list"
                        },
                        {
                            "source": "#pindel.cwl/reference",
                            "id": "#pindel.cwl/region_filter/reference"
                        },
                        {
                            "source": "#pindel.cwl/index/indexed_vcf",
                            "id": "#pindel.cwl/region_filter/vcf"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/region_filter/filtered_vcf"
                    ],
                    "id": "#pindel.cwl/region_filter"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/remove_end_tags/processed_vcf",
                            "id": "#pindel.cwl/reindex/vcf"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/reindex/indexed_vcf"
                    ],
                    "id": "#pindel.cwl/reindex"
                },
                {
                    "run": "#remove_end_tags.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/region_filter/filtered_vcf",
                            "id": "#pindel.cwl/remove_end_tags/vcf"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/remove_end_tags/processed_vcf"
                    ],
                    "id": "#pindel.cwl/remove_end_tags"
                },
                {
                    "run": "#pindel_somatic_filter.cwl",
                    "in": [
                        {
                            "source": "#pindel.cwl/cat_all/all_chromosome_pindel_head",
                            "id": "#pindel.cwl/somaticfilter/pindel_output_summary"
                        },
                        {
                            "source": "#pindel.cwl/reference",
                            "id": "#pindel.cwl/somaticfilter/reference"
                        }
                    ],
                    "out": [
                        "#pindel.cwl/somaticfilter/vcf"
                    ],
                    "id": "#pindel.cwl/somaticfilter"
                }
            ],
            "id": "#pindel.cwl"
        },
        {
            "class": "Workflow",
            "label": "Per-chromosome pindel",
            "requirements": [
                {
                    "class": "MultipleInputFeatureRequirement"
                }
            ],
            "inputs": [
                {
                    "type": "string",
                    "id": "#pindel_cat.cwl/chromosome"
                },
                {
                    "type": "int",
                    "default": 400,
                    "id": "#pindel_cat.cwl/insert_size"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#pindel_cat.cwl/normal_bam"
                },
                {
                    "type": "string",
                    "id": "#pindel_cat.cwl/reference"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#pindel_cat.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#pindel_cat.cwl/cat/pindel_out",
                    "id": "#pindel_cat.cwl/per_chromosome_pindel_out"
                }
            ],
            "steps": [
                {
                    "run": "#cat_out.cwl",
                    "in": [
                        {
                            "source": [
                                "#pindel_cat.cwl/pindel/deletions",
                                "#pindel_cat.cwl/pindel/insertions",
                                "#pindel_cat.cwl/pindel/tandems",
                                "#pindel_cat.cwl/pindel/long_insertions",
                                "#pindel_cat.cwl/pindel/inversions"
                            ],
                            "id": "#pindel_cat.cwl/cat/pindel_outs"
                        }
                    ],
                    "out": [
                        "#pindel_cat.cwl/cat/pindel_out"
                    ],
                    "id": "#pindel_cat.cwl/cat"
                },
                {
                    "run": "#pindel.cwl_2",
                    "in": [
                        {
                            "source": "#pindel_cat.cwl/chromosome",
                            "id": "#pindel_cat.cwl/pindel/chromosome"
                        },
                        {
                            "source": "#pindel_cat.cwl/insert_size",
                            "id": "#pindel_cat.cwl/pindel/insert_size"
                        },
                        {
                            "source": "#pindel_cat.cwl/normal_bam",
                            "id": "#pindel_cat.cwl/pindel/normal_bam"
                        },
                        {
                            "source": "#pindel_cat.cwl/reference",
                            "id": "#pindel_cat.cwl/pindel/reference"
                        },
                        {
                            "source": "#pindel_cat.cwl/tumor_bam",
                            "id": "#pindel_cat.cwl/pindel/tumor_bam"
                        }
                    ],
                    "out": [
                        "#pindel_cat.cwl/pindel/deletions",
                        "#pindel_cat.cwl/pindel/insertions",
                        "#pindel_cat.cwl/pindel/tandems",
                        "#pindel_cat.cwl/pindel/long_insertions",
                        "#pindel_cat.cwl/pindel/inversions"
                    ],
                    "id": "#pindel_cat.cwl/pindel"
                }
            ],
            "id": "#pindel_cat.cwl"
        },
        {
            "class": "Workflow",
            "label": "strelka workflow",
            "requirements": [
                {
                    "class": "ScatterFeatureRequirement"
                },
                {
                    "class": "SubworkflowFeatureRequirement"
                },
                {
                    "class": "MultipleInputFeatureRequirement"
                },
                {
                    "class": "StepInputExpressionRequirement"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 8,
                    "id": "#strelka_and_post_processing.cwl/cpu_reserved"
                },
                {
                    "type": "boolean",
                    "id": "#strelka_and_post_processing.cwl/exome_mode"
                },
                {
                    "type": "File",
                    "id": "#strelka_and_post_processing.cwl/interval_list"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".bai",
                        "^.bai"
                    ],
                    "id": "#strelka_and_post_processing.cwl/normal_bam"
                },
                {
                    "type": "string",
                    "id": "#strelka_and_post_processing.cwl/reference"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".bai",
                        "^.bai"
                    ],
                    "id": "#strelka_and_post_processing.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#strelka_and_post_processing.cwl/filter/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#strelka_and_post_processing.cwl/filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#strelka_and_post_processing.cwl/filter/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#strelka_and_post_processing.cwl/unfiltered_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#fp_filter.cwl",
                    "in": [
                        {
                            "source": "#strelka_and_post_processing.cwl/tumor_bam",
                            "id": "#strelka_and_post_processing.cwl/filter/bam"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/reference",
                            "id": "#strelka_and_post_processing.cwl/filter/reference"
                        },
                        {
                            "valueFrom": "strelka",
                            "id": "#strelka_and_post_processing.cwl/filter/variant_caller"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/region_filter/filtered_vcf",
                            "id": "#strelka_and_post_processing.cwl/filter/vcf"
                        }
                    ],
                    "out": [
                        "#strelka_and_post_processing.cwl/filter/unfiltered_vcf",
                        "#strelka_and_post_processing.cwl/filter/filtered_vcf"
                    ],
                    "id": "#strelka_and_post_processing.cwl/filter"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#strelka_and_post_processing.cwl/merge/merged_vcf",
                            "id": "#strelka_and_post_processing.cwl/index_full/vcf"
                        }
                    ],
                    "out": [
                        "#strelka_and_post_processing.cwl/index_full/indexed_vcf"
                    ],
                    "id": "#strelka_and_post_processing.cwl/index_full"
                },
                {
                    "run": "#merge_vcf.cwl",
                    "in": [
                        {
                            "source": "#strelka_and_post_processing.cwl/process/processed_vcf",
                            "id": "#strelka_and_post_processing.cwl/merge/vcfs"
                        }
                    ],
                    "out": [
                        "#strelka_and_post_processing.cwl/merge/merged_vcf"
                    ],
                    "id": "#strelka_and_post_processing.cwl/merge"
                },
                {
                    "scatter": "#strelka_and_post_processing.cwl/process/vcf",
                    "run": "#strelka_process_vcf.cwl",
                    "in": [
                        {
                            "source": [
                                "#strelka_and_post_processing.cwl/strelka/snvs",
                                "#strelka_and_post_processing.cwl/strelka/indels"
                            ],
                            "id": "#strelka_and_post_processing.cwl/process/vcf"
                        }
                    ],
                    "out": [
                        "#strelka_and_post_processing.cwl/process/processed_vcf"
                    ],
                    "id": "#strelka_and_post_processing.cwl/process"
                },
                {
                    "run": "#select_variants.cwl",
                    "in": [
                        {
                            "source": "#strelka_and_post_processing.cwl/interval_list",
                            "id": "#strelka_and_post_processing.cwl/region_filter/interval_list"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/reference",
                            "id": "#strelka_and_post_processing.cwl/region_filter/reference"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/index_full/indexed_vcf",
                            "id": "#strelka_and_post_processing.cwl/region_filter/vcf"
                        }
                    ],
                    "out": [
                        "#strelka_and_post_processing.cwl/region_filter/filtered_vcf"
                    ],
                    "id": "#strelka_and_post_processing.cwl/region_filter"
                },
                {
                    "run": "#strelka.cwl",
                    "in": [
                        {
                            "source": "#strelka_and_post_processing.cwl/cpu_reserved",
                            "id": "#strelka_and_post_processing.cwl/strelka/cpu_reserved"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/exome_mode",
                            "id": "#strelka_and_post_processing.cwl/strelka/exome_mode"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/normal_bam",
                            "id": "#strelka_and_post_processing.cwl/strelka/normal_bam"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/reference",
                            "id": "#strelka_and_post_processing.cwl/strelka/reference"
                        },
                        {
                            "source": "#strelka_and_post_processing.cwl/tumor_bam",
                            "id": "#strelka_and_post_processing.cwl/strelka/tumor_bam"
                        }
                    ],
                    "out": [
                        "#strelka_and_post_processing.cwl/strelka/indels",
                        "#strelka_and_post_processing.cwl/strelka/snvs"
                    ],
                    "id": "#strelka_and_post_processing.cwl/strelka"
                }
            ],
            "id": "#strelka_and_post_processing.cwl"
        },
        {
            "class": "Workflow",
            "label": "process VCF workflow",
            "inputs": [
                {
                    "type": "File",
                    "id": "#strelka_process_vcf.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#strelka_process_vcf.cwl/index/indexed_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#strelka_process_vcf.cwl/processed_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#add_strelka_gt.cwl",
                    "in": [
                        {
                            "source": "#strelka_process_vcf.cwl/vcf",
                            "id": "#strelka_process_vcf.cwl/add_gt/vcf"
                        }
                    ],
                    "out": [
                        "#strelka_process_vcf.cwl/add_gt/processed_vcf"
                    ],
                    "id": "#strelka_process_vcf.cwl/add_gt"
                },
                {
                    "run": "#bgzip.cwl",
                    "in": [
                        {
                            "source": "#strelka_process_vcf.cwl/add_gt/processed_vcf",
                            "id": "#strelka_process_vcf.cwl/bgzip/file"
                        }
                    ],
                    "out": [
                        "#strelka_process_vcf.cwl/bgzip/bgzipped_file"
                    ],
                    "id": "#strelka_process_vcf.cwl/bgzip"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#strelka_process_vcf.cwl/bgzip/bgzipped_file",
                            "id": "#strelka_process_vcf.cwl/index/vcf"
                        }
                    ],
                    "out": [
                        "#strelka_process_vcf.cwl/index/indexed_vcf"
                    ],
                    "id": "#strelka_process_vcf.cwl/index"
                }
            ],
            "id": "#strelka_process_vcf.cwl"
        },
        {
            "class": "Workflow",
            "label": "varscan somatic workflow",
            "inputs": [
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#varscan.cwl/max_normal_freq"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#varscan.cwl/min_coverage"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#varscan.cwl/min_var_freq"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#varscan.cwl/normal_bam"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#varscan.cwl/p_value"
                },
                {
                    "type": "string",
                    "id": "#varscan.cwl/reference"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#varscan.cwl/roi_bed"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#varscan.cwl/strand_filter"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#varscan.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_indels/germline_hc",
                    "id": "#varscan.cwl/germline_hc_indels"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_snvs/germline_hc",
                    "id": "#varscan.cwl/germline_hc_snvs"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_indels/germline",
                    "id": "#varscan.cwl/germline_indels"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_snvs/germline",
                    "id": "#varscan.cwl/germline_snvs"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/somatic/indels",
                    "id": "#varscan.cwl/indels"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_indels/loh_hc",
                    "id": "#varscan.cwl/loh_hc_indels"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_snvs/loh_hc",
                    "id": "#varscan.cwl/loh_hc_snvs"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_indels/loh",
                    "id": "#varscan.cwl/loh_indels"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_snvs/loh",
                    "id": "#varscan.cwl/loh_snvs"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/somatic/snvs",
                    "id": "#varscan.cwl/snvs"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_indels/somatic_hc",
                    "id": "#varscan.cwl/somatic_hc_indels"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_snvs/somatic_hc",
                    "id": "#varscan.cwl/somatic_hc_snvs"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_indels/somatic",
                    "id": "#varscan.cwl/somatic_indels"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan.cwl/process_somatic_snvs/somatic",
                    "id": "#varscan.cwl/somatic_snvs"
                }
            ],
            "steps": [
                {
                    "run": "#varscan_process_somatic.cwl",
                    "in": [
                        {
                            "source": "#varscan.cwl/max_normal_freq",
                            "id": "#varscan.cwl/process_somatic_indels/max_normal_freq"
                        },
                        {
                            "source": "#varscan.cwl/somatic/indels",
                            "id": "#varscan.cwl/process_somatic_indels/variants"
                        }
                    ],
                    "out": [
                        "#varscan.cwl/process_somatic_indels/somatic_hc",
                        "#varscan.cwl/process_somatic_indels/somatic",
                        "#varscan.cwl/process_somatic_indels/germline_hc",
                        "#varscan.cwl/process_somatic_indels/germline",
                        "#varscan.cwl/process_somatic_indels/loh_hc",
                        "#varscan.cwl/process_somatic_indels/loh"
                    ],
                    "id": "#varscan.cwl/process_somatic_indels"
                },
                {
                    "run": "#varscan_process_somatic.cwl",
                    "in": [
                        {
                            "source": "#varscan.cwl/max_normal_freq",
                            "id": "#varscan.cwl/process_somatic_snvs/max_normal_freq"
                        },
                        {
                            "source": "#varscan.cwl/somatic/snvs",
                            "id": "#varscan.cwl/process_somatic_snvs/variants"
                        }
                    ],
                    "out": [
                        "#varscan.cwl/process_somatic_snvs/somatic_hc",
                        "#varscan.cwl/process_somatic_snvs/somatic",
                        "#varscan.cwl/process_somatic_snvs/germline_hc",
                        "#varscan.cwl/process_somatic_snvs/germline",
                        "#varscan.cwl/process_somatic_snvs/loh_hc",
                        "#varscan.cwl/process_somatic_snvs/loh"
                    ],
                    "id": "#varscan.cwl/process_somatic_snvs"
                },
                {
                    "run": "#varscan_somatic.cwl",
                    "in": [
                        {
                            "source": "#varscan.cwl/min_coverage",
                            "id": "#varscan.cwl/somatic/min_coverage"
                        },
                        {
                            "source": "#varscan.cwl/min_var_freq",
                            "id": "#varscan.cwl/somatic/min_var_freq"
                        },
                        {
                            "source": "#varscan.cwl/normal_bam",
                            "id": "#varscan.cwl/somatic/normal_bam"
                        },
                        {
                            "source": "#varscan.cwl/p_value",
                            "id": "#varscan.cwl/somatic/p_value"
                        },
                        {
                            "source": "#varscan.cwl/reference",
                            "id": "#varscan.cwl/somatic/reference"
                        },
                        {
                            "source": "#varscan.cwl/roi_bed",
                            "id": "#varscan.cwl/somatic/roi_bed"
                        },
                        {
                            "source": "#varscan.cwl/strand_filter",
                            "id": "#varscan.cwl/somatic/strand_filter"
                        },
                        {
                            "source": "#varscan.cwl/tumor_bam",
                            "id": "#varscan.cwl/somatic/tumor_bam"
                        }
                    ],
                    "out": [
                        "#varscan.cwl/somatic/snvs",
                        "#varscan.cwl/somatic/indels"
                    ],
                    "id": "#varscan.cwl/somatic"
                }
            ],
            "id": "#varscan.cwl"
        },
        {
            "class": "Workflow",
            "label": "Varscan Workflow",
            "requirements": [
                {
                    "class": "SubworkflowFeatureRequirement"
                },
                {
                    "class": "MultipleInputFeatureRequirement"
                },
                {
                    "class": "StepInputExpressionRequirement"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "id": "#varscan_pre_and_post_processing.cwl/interval_list"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/max_normal_freq"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 8,
                    "id": "#varscan_pre_and_post_processing.cwl/min_coverage"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.1,
                    "id": "#varscan_pre_and_post_processing.cwl/min_var_freq"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/normal_bam"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.99,
                    "id": "#varscan_pre_and_post_processing.cwl/p_value"
                },
                {
                    "type": "string",
                    "id": "#varscan_pre_and_post_processing.cwl/reference"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 0,
                    "id": "#varscan_pre_and_post_processing.cwl/strand_filter"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#varscan_pre_and_post_processing.cwl/filter/filtered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/filtered_vcf"
                },
                {
                    "type": "File",
                    "outputSource": "#varscan_pre_and_post_processing.cwl/filter/unfiltered_vcf",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/unfiltered_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#bgzip_and_index.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/varscan/somatic_hc_indels",
                            "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_indels/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_indels/indexed_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_indels"
                },
                {
                    "run": "#bgzip_and_index.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/varscan/somatic_hc_snvs",
                            "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_snvs/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_snvs/indexed_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_snvs"
                },
                {
                    "run": "#bgzip_and_index.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/varscan/somatic_indels",
                            "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_indels/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/bgzip_and_index_indels/indexed_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_indels"
                },
                {
                    "run": "#bgzip_and_index.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/varscan/somatic_snvs",
                            "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_snvs/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/bgzip_and_index_snvs/indexed_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_snvs"
                },
                {
                    "run": "#fp_filter.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/tumor_bam",
                            "id": "#varscan_pre_and_post_processing.cwl/filter/bam"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/min_var_freq",
                            "id": "#varscan_pre_and_post_processing.cwl/filter/min_var_freq"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/reference",
                            "id": "#varscan_pre_and_post_processing.cwl/filter/reference"
                        },
                        {
                            "valueFrom": "varscan",
                            "id": "#varscan_pre_and_post_processing.cwl/filter/variant_caller"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/index/indexed_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/filter/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/filter/unfiltered_vcf",
                        "#varscan_pre_and_post_processing.cwl/filter/filtered_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/filter"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/merge/merged_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/index/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/index/indexed_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/index"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/merge_indels/merged_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/index_indels/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/index_indels/indexed_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/index_indels"
                },
                {
                    "run": "#index_vcf.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/merge_snvs/merged_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/index_snvs/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/index_snvs/indexed_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/index_snvs"
                },
                {
                    "run": "#intervals_to_bed.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/interval_list",
                            "id": "#varscan_pre_and_post_processing.cwl/intervals_to_bed/interval_list"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/intervals_to_bed/interval_bed"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/intervals_to_bed"
                },
                {
                    "run": "#merge_vcf.cwl",
                    "in": [
                        {
                            "source": [
                                "#varscan_pre_and_post_processing.cwl/index_snvs/indexed_vcf",
                                "#varscan_pre_and_post_processing.cwl/index_indels/indexed_vcf"
                            ],
                            "id": "#varscan_pre_and_post_processing.cwl/merge/vcfs"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/merge/merged_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/merge"
                },
                {
                    "run": "#set_filter_status.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_indels/indexed_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/merge_indels/filtered_vcf"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/reference",
                            "id": "#varscan_pre_and_post_processing.cwl/merge_indels/reference"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_indels/indexed_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/merge_indels/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/merge_indels/merged_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/merge_indels"
                },
                {
                    "run": "#set_filter_status.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_hc_snvs/indexed_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/merge_snvs/filtered_vcf"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/reference",
                            "id": "#varscan_pre_and_post_processing.cwl/merge_snvs/reference"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/bgzip_and_index_snvs/indexed_vcf",
                            "id": "#varscan_pre_and_post_processing.cwl/merge_snvs/vcf"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/merge_snvs/merged_vcf"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/merge_snvs"
                },
                {
                    "run": "#varscan.cwl",
                    "in": [
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/max_normal_freq",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/max_normal_freq"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/min_coverage",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/min_coverage"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/min_var_freq",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/min_var_freq"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/normal_bam",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/normal_bam"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/p_value",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/p_value"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/reference",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/reference"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/intervals_to_bed/interval_bed",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/roi_bed"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/strand_filter",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/strand_filter"
                        },
                        {
                            "source": "#varscan_pre_and_post_processing.cwl/tumor_bam",
                            "id": "#varscan_pre_and_post_processing.cwl/varscan/tumor_bam"
                        }
                    ],
                    "out": [
                        "#varscan_pre_and_post_processing.cwl/varscan/somatic_snvs",
                        "#varscan_pre_and_post_processing.cwl/varscan/somatic_indels",
                        "#varscan_pre_and_post_processing.cwl/varscan/somatic_hc_snvs",
                        "#varscan_pre_and_post_processing.cwl/varscan/somatic_hc_indels"
                    ],
                    "id": "#varscan_pre_and_post_processing.cwl/varscan"
                }
            ],
            "id": "#varscan_pre_and_post_processing.cwl"
        },
        {
            "class": "Workflow",
            "label": "Add snv and indel bam-readcount files to a vcf",
            "requirements": [
                {
                    "class": "SubworkflowFeatureRequirement"
                }
            ],
            "inputs": [
                {
                    "type": [
                        {
                            "type": "enum",
                            "symbols": [
                                "#vcf_readcount_annotator.cwl/data_type/DNA",
                                "#vcf_readcount_annotator.cwl/data_type/RNA"
                            ]
                        }
                    ],
                    "id": "#vcf_readcount_annotator.cwl/data_type"
                },
                {
                    "type": "File",
                    "id": "#vcf_readcount_annotator.cwl/indel_bam_readcount_tsv"
                },
                {
                    "type": "string",
                    "id": "#vcf_readcount_annotator.cwl/sample_name"
                },
                {
                    "type": "File",
                    "id": "#vcf_readcount_annotator.cwl/snv_bam_readcount_tsv"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#vcf_readcount_annotator.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputSource": "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf/annotated_bam_readcount_vcf",
                    "id": "#vcf_readcount_annotator.cwl/annotated_bam_readcount_vcf"
                }
            ],
            "steps": [
                {
                    "run": "#vcf_readcount_annotator.cwl_2",
                    "in": [
                        {
                            "source": "#vcf_readcount_annotator.cwl/indel_bam_readcount_tsv",
                            "id": "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf/bam_readcount_tsv"
                        },
                        {
                            "source": "#vcf_readcount_annotator.cwl/data_type",
                            "id": "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf/data_type"
                        },
                        {
                            "source": "#vcf_readcount_annotator.cwl/sample_name",
                            "id": "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf/sample_name"
                        },
                        {
                            "default": "indel",
                            "id": "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf/variant_type"
                        },
                        {
                            "source": "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf/annotated_bam_readcount_vcf",
                            "id": "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf/vcf"
                        }
                    ],
                    "out": [
                        "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf/annotated_bam_readcount_vcf"
                    ],
                    "id": "#vcf_readcount_annotator.cwl/add_indel_bam_readcount_to_vcf"
                },
                {
                    "run": "#vcf_readcount_annotator.cwl_2",
                    "in": [
                        {
                            "source": "#vcf_readcount_annotator.cwl/snv_bam_readcount_tsv",
                            "id": "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf/bam_readcount_tsv"
                        },
                        {
                            "source": "#vcf_readcount_annotator.cwl/data_type",
                            "id": "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf/data_type"
                        },
                        {
                            "source": "#vcf_readcount_annotator.cwl/sample_name",
                            "id": "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf/sample_name"
                        },
                        {
                            "default": "snv",
                            "id": "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf/variant_type"
                        },
                        {
                            "source": "#vcf_readcount_annotator.cwl/vcf",
                            "id": "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf/vcf"
                        }
                    ],
                    "out": [
                        "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf/annotated_bam_readcount_vcf"
                    ],
                    "id": "#vcf_readcount_annotator.cwl/add_snv_bam_readcount_to_vcf"
                }
            ],
            "id": "#vcf_readcount_annotator.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "add GT tags",
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                "/usr/bin/perl",
                "/usr/bin/add_strelka_gt.pl",
                "$(inputs.vcf.path)",
                "$(runtime.outdir)"
            ],
            "inputs": [
                {
                    "type": "File",
                    "id": "#add_strelka_gt.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "add_gt.vcf"
                    },
                    "id": "#add_strelka_gt.cwl/processed_vcf"
                }
            ],
            "id": "#add_strelka_gt.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "add VEP annotation to report",
            "baseCommand": [
                "vep-annotation-reporter"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "griffithlab/vatools:3.0.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/variants.annotated.tsv"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "-t"
                    },
                    "id": "#add_vep_fields_to_table.cwl/tsv"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#add_vep_fields_to_table.cwl/vcf"
                },
                {
                    "type": {
                        "type": "array",
                        "items": "string"
                    },
                    "default": [
                        "Consequence",
                        "SYMBOL",
                        "Feature",
                        "HGVSc",
                        "HGVSp"
                    ],
                    "inputBinding": {
                        "position": 2
                    },
                    "id": "#add_vep_fields_to_table.cwl/vep_fields"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "variants.annotated.tsv"
                    },
                    "id": "#add_vep_fields_to_table.cwl/annotated_variants_tsv"
                }
            ],
            "id": "#add_vep_fields_to_table.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "run bam-readcount",
            "baseCommand": [
                "/usr/bin/python",
                "/usr/bin/bam_readcount_helper.py"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/bam_readcount_helper-cwl:1.0.0"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                {
                    "valueFrom": "$(runtime.outdir)",
                    "position": -3
                }
            ],
            "stdout": "$(inputs.sample)_bam_readcount.tsv",
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "position": -4
                    },
                    "secondaryFiles": [
                        ".bai"
                    ],
                    "id": "#bam_readcount.cwl/bam"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 20,
                    "inputBinding": {
                        "position": -2
                    },
                    "id": "#bam_readcount.cwl/min_base_quality"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 0,
                    "inputBinding": {
                        "position": -1
                    },
                    "id": "#bam_readcount.cwl/min_mapping_quality"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "position": -5
                    },
                    "id": "#bam_readcount.cwl/reference_fasta"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "position": -6
                    },
                    "id": "#bam_readcount.cwl/sample"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": -7
                    },
                    "id": "#bam_readcount.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "$(inputs.sample)_bam_readcount_indel.tsv"
                    },
                    "id": "#bam_readcount.cwl/indel_bam_readcount_tsv"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "$(inputs.sample)_bam_readcount_snv.tsv"
                    },
                    "id": "#bam_readcount.cwl/snv_bam_readcount_tsv"
                }
            ],
            "id": "#bam_readcount.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "bgzip VCF",
            "baseCommand": [
                "/opt/htslib/bin/bgzip"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/samtools-cwl:1.0.0"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "stdout": "$(inputs.file.basename).gz",
            "arguments": [
                "-c"
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#bgzip.cwl/file"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "id": "#bgzip.cwl/bgzipped_file",
                    "outputBinding": {
                        "glob": "$(inputs.file.basename).gz"
                    }
                }
            ],
            "id": "#bgzip.cwl"
        },
        {
            "class": "CommandLineTool",
            "baseCommand": [
                "/bin/cat"
            ],
            "requirements": [
                {
                    "class": "ShellCommandRequirement"
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "ubuntu:xenial"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                {
                    "shellQuote": false,
                    "valueFrom": "|"
                },
                "/bin/grep",
                "ChrID",
                "/dev/stdin"
            ],
            "stdout": "all_chromosome_pindel.head",
            "inputs": [
                {
                    "type": {
                        "type": "array",
                        "items": "File"
                    },
                    "inputBinding": {
                        "position": -1
                    },
                    "id": "#cat_all.cwl/chromosome_pindel_outs"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "id": "#cat_all.cwl/all_chromosome_pindel_head",
                    "outputBinding": {
                        "glob": "all_chromosome_pindel.head"
                    }
                }
            ],
            "id": "#cat_all.cwl"
        },
        {
            "class": "CommandLineTool",
            "baseCommand": [
                "/bin/cat"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "ubuntu:xenial"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "stdout": "per_chromosome_pindel.out",
            "inputs": [
                {
                    "type": {
                        "type": "array",
                        "items": "File"
                    },
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#cat_out.cwl/pindel_outs"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "id": "#cat_out.cwl/pindel_out",
                    "outputBinding": {
                        "glob": "per_chromosome_pindel.out"
                    }
                }
            ],
            "id": "#cat_out.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "CombineVariants (GATK 3.6)",
            "baseCommand": [
                "/usr/bin/java",
                "-Xmx8g",
                "-jar",
                "/opt/GenomeAnalysisTK.jar",
                "-T",
                "CombineVariants"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 9000,
                    "tmpdirMin": 25000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "arguments": [
                "-genotypeMergeOptions",
                "PRIORITIZE",
                "--rod_priority_list",
                "mutect,varscan,strelka,pindel,docm",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/combined.vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant:docm",
                        "position": 6
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#combine_variants.cwl/docm_vcf"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant:mutect",
                        "position": 2
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#combine_variants.cwl/mutect_vcf"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant:pindel",
                        "position": 5
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#combine_variants.cwl/pindel_vcf"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-R",
                        "position": 1
                    },
                    "id": "#combine_variants.cwl/reference"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant:strelka",
                        "position": 4
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#combine_variants.cwl/strelka_vcf"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant:varscan",
                        "position": 3
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#combine_variants.cwl/varscan_vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "combined.vcf.gz"
                    },
                    "id": "#combine_variants.cwl/combined_vcf"
                }
            ],
            "id": "#combine_variants.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "HaplotypeCaller (GATK 3.6)",
            "baseCommand": [
                "/usr/bin/java",
                "-Xmx8g",
                "-jar",
                "/opt/GenomeAnalysisTK.jar",
                "-T",
                "HaplotypeCaller"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 9000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/gatk-cwl:3.6.0"
                }
            ],
            "arguments": [
                "-gt_mode",
                "GENOTYPE_GIVEN_ALLELES",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/docm_out.vcf"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "-I",
                        "position": 3
                    },
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#docm_gatk_haplotype_caller.cwl/bam"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--alleles",
                        "position": 4
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#docm_gatk_haplotype_caller.cwl/docm_vcf"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "-L",
                        "position": 5
                    },
                    "id": "#docm_gatk_haplotype_caller.cwl/interval_list"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "-I",
                        "position": 2
                    },
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#docm_gatk_haplotype_caller.cwl/normal_bam"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-R",
                        "position": 1
                    },
                    "id": "#docm_gatk_haplotype_caller.cwl/reference"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "docm_out.vcf"
                    },
                    "id": "#docm_gatk_haplotype_caller.cwl/docm_out"
                }
            ],
            "id": "#docm_gatk_haplotype_caller.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "cle_annotated_vcf_filter",
            "baseCommand": [
                "/usr/bin/perl",
                "/usr/bin/docm_and_coding_indel_selection.pl"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                "$(inputs.vcf.path)",
                "$(runtime.outdir)"
            ],
            "inputs": [
                {
                    "type": "boolean",
                    "inputBinding": {
                        "prefix": "filter",
                        "position": 1
                    },
                    "id": "#filter_vcf_cle.cwl/filter"
                },
                {
                    "type": "File",
                    "id": "#filter_vcf_cle.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "annotated_filtered.vcf"
                    },
                    "id": "#filter_vcf_cle.cwl/cle_filtered_vcf"
                }
            ],
            "id": "#filter_vcf_cle.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "gnomADe_AF filter",
            "baseCommand": [
                "/usr/bin/perl",
                "/usr/bin/vcf_check.pl"
            ],
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/vep_helper-cwl:1.0.0"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                {
                    "valueFrom": "$(inputs.vcf.path)"
                },
                {
                    "valueFrom": "$(runtime.outdir)/annotated.af_filtered.vcf"
                },
                "/usr/bin/perl",
                "/opt/vep/src/ensembl-vep/filter_vep",
                "--format",
                "vcf",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/annotated.af_filtered.vcf"
                }
            ],
            "inputs": [
                {
                    "type": "float",
                    "inputBinding": {
                        "valueFrom": "${\n    return [\n        \"--filter\",\n        [\n            \"gnomADe_AF\", \"<\", inputs.maximum_population_allele_frequency,\n            \"or not\", \"gnomADe_AF\"\n        ].join(\" \")\n    ]\n}\n",
                        "position": 2
                    },
                    "id": "#filter_vcf_gnomADe_allele_freq.cwl/maximum_population_allele_frequency"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "-i",
                        "position": 1
                    },
                    "id": "#filter_vcf_gnomADe_allele_freq.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "annotated.af_filtered.vcf"
                    },
                    "id": "#filter_vcf_gnomADe_allele_freq.cwl/filtered_vcf"
                }
            ],
            "id": "#filter_vcf_gnomADe_allele_freq.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "filter vcf for variants with high percentage of mapq0 reads",
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/mapq0-filter:v0.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 8000,
                    "tmpdirMin": 10000
                }
            ],
            "arguments": [
                "/bin/bash",
                "/usr/bin/mapq0_vcf_filter.sh",
                {
                    "valueFrom": "$(runtime.outdir)/mapq_filtered.vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": "string",
                    "inputBinding": {
                        "position": 3
                    },
                    "id": "#filter_vcf_mapq0.cwl/reference"
                },
                {
                    "type": "float",
                    "inputBinding": {
                        "position": 4
                    },
                    "id": "#filter_vcf_mapq0.cwl/threshold"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 2
                    },
                    "secondaryFiles": [
                        ".bai"
                    ],
                    "id": "#filter_vcf_mapq0.cwl/tumor_bam"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#filter_vcf_mapq0.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "mapq_filtered.vcf.gz"
                    },
                    "id": "#filter_vcf_mapq0.cwl/mapq0_filtered_vcf"
                }
            ],
            "id": "#filter_vcf_mapq0.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "use the binomial/llr somatic filter to weed out low confidence variants",
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/somatic-llr-filter:v0.3"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "baseCommand": [
                "/opt/conda/bin/python3",
                "/usr/bin/somatic_llr_filter.py"
            ],
            "arguments": [
                "--overwrite",
                {
                    "valueFrom": "$(runtime.outdir)/somatic_llr_filtered.vcf"
                }
            ],
            "inputs": [
                {
                    "type": "float",
                    "inputBinding": {
                        "prefix": "--llr-threshold",
                        "position": -2
                    },
                    "id": "#filter_vcf_somatic_llr.cwl/threshold"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": -1
                    },
                    "id": "#filter_vcf_somatic_llr.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "somatic_llr_filtered.vcf"
                    },
                    "id": "#filter_vcf_somatic_llr.cwl/somatic_llr_filtered_vcf"
                }
            ],
            "id": "#filter_vcf_somatic_llr.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "False Positive filter",
            "baseCommand": [
                "/usr/bin/perl",
                "/usr/bin/fpfilter.pl"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 6000,
                    "tmpdirMin": 25000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/fp_filter-cwl:1.0.0"
                }
            ],
            "arguments": [
                "--bam-readcount",
                "/usr/bin/bam-readcount",
                "--samtools",
                "/opt/samtools/bin/samtools",
                "--output",
                {
                    "valueFrom": "$(runtime.outdir)/$(inputs.output_vcf_basename).vcf"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--bam-file",
                        "position": 2
                    },
                    "id": "#fp_filter.cwl_2/bam"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.05,
                    "inputBinding": {
                        "prefix": "--min-var-freq",
                        "position": 5
                    },
                    "id": "#fp_filter.cwl_2/min_var_freq"
                },
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "default": "fpfilter",
                    "id": "#fp_filter.cwl_2/output_vcf_basename"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "--reference",
                        "position": 1
                    },
                    "id": "#fp_filter.cwl_2/reference"
                },
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "default": "TUMOR",
                    "inputBinding": {
                        "prefix": "--sample",
                        "position": 4
                    },
                    "id": "#fp_filter.cwl_2/sample_name"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--vcf-file",
                        "position": 3
                    },
                    "id": "#fp_filter.cwl_2/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "$(inputs.output_vcf_basename).vcf"
                    },
                    "id": "#fp_filter.cwl_2/filtered_vcf"
                }
            ],
            "id": "#fp_filter.cwl_2"
        },
        {
            "class": "CommandLineTool",
            "baseCommand": [
                "bash",
                "-c",
                "/bin/grep -v '^@' $1 | /usr/bin/cut -f 1 | /usr/bin/sort | /usr/bin/uniq",
                "--"
            ],
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "ubuntu:xenial"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "stdout": "chromosome.list",
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#get_chromosome_list.cwl/interval_list"
                }
            ],
            "outputs": [
                {
                    "type": {
                        "type": "array",
                        "items": "string"
                    },
                    "outputBinding": {
                        "glob": "chromosome.list",
                        "loadContents": true,
                        "outputEval": "$( self[0].contents.split(\"\\n\").slice(0, -1))"
                    },
                    "id": "#get_chromosome_list.cwl/chromosome_list"
                }
            ],
            "id": "#get_chromosome_list.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "vcf index",
            "arguments": [
                "cp",
                "$(inputs.vcf.path)",
                "$(runtime.outdir)/$(inputs.vcf.basename)",
                {
                    "valueFrom": " && ",
                    "shellQuote": false
                },
                "/usr/bin/tabix",
                "-p",
                "vcf"
            ],
            "requirements": [
                {
                    "class": "ShellCommandRequirement"
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/samtools-cwl:1.0.0"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "valueFrom": "$(self.basename)",
                        "position": 1
                    },
                    "id": "#index_vcf.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "outputBinding": {
                        "glob": "$(inputs.vcf.basename)"
                    },
                    "id": "#index_vcf.cwl/indexed_vcf"
                }
            ],
            "id": "#index_vcf.cwl"
        },
        {
            "class": "CommandLineTool",
            "baseCommand": [
                "/usr/bin/perl",
                "/usr/bin/intervals_to_bed.pl"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/perl_helper-cwl:1.0.0"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "stdout": "interval_list.bed",
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#intervals_to_bed.cwl/interval_list"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "id": "#intervals_to_bed.cwl/interval_bed",
                    "outputBinding": {
                        "glob": "interval_list.bed"
                    }
                }
            ],
            "id": "#intervals_to_bed.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "vcf merge",
            "baseCommand": [
                "/opt/bcftools/bin/bcftools",
                "concat"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                "--allow-overlaps",
                "--remove-duplicates",
                "--output-type",
                "z",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/$(inputs.merged_vcf_basename).vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "default": "merged",
                    "id": "#merge_vcf.cwl/merged_vcf_basename"
                },
                {
                    "type": {
                        "type": "array",
                        "items": "File"
                    },
                    "inputBinding": {
                        "position": 1
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#merge_vcf.cwl/vcfs"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "$(inputs.merged_vcf_basename).vcf.gz"
                    },
                    "id": "#merge_vcf.cwl/merged_vcf"
                }
            ],
            "id": "#merge_vcf.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "mutect2 (GATK 3.6)",
            "baseCommand": [
                "/usr/bin/java",
                "-jar",
                "/opt/GenomeAnalysisTK.jar",
                "-T",
                "MuTect2"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 20000,
                    "tmpdirMin": 100000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "arguments": [
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/mutect.vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "boolean"
                    ],
                    "inputBinding": {
                        "prefix": "--artifact_detection_mode",
                        "position": 7
                    },
                    "id": "#mutect.cwl_2/artifact_detection_mode"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "--cosmic",
                        "position": 6
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl_2/cosmic_vcf"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "--dbsnp",
                        "position": 5
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl_2/dbsnp_vcf"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "-L",
                        "position": 4
                    },
                    "id": "#mutect.cwl_2/interval_list"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "inputBinding": {
                        "prefix": "--max_alt_allele_in_normal_fraction",
                        "position": 10
                    },
                    "id": "#mutect.cwl_2/max_alt_allele_in_normal_fraction"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "inputBinding": {
                        "prefix": "--max_alt_alleles_in_normal_count",
                        "position": 9
                    },
                    "id": "#mutect.cwl_2/max_alt_alleles_in_normal_count"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "-I:normal",
                        "position": 3
                    },
                    "secondaryFiles": [
                        ".bai"
                    ],
                    "id": "#mutect.cwl_2/normal_bam"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "-PON",
                        "position": 8
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl_2/panel_of_normals_vcf"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-R",
                        "position": 1
                    },
                    "id": "#mutect.cwl_2/reference"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "-I:tumor",
                        "position": 2
                    },
                    "secondaryFiles": [
                        ".bai"
                    ],
                    "id": "#mutect.cwl_2/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "mutect.vcf.gz"
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#mutect.cwl_2/vcf"
                }
            ],
            "id": "#mutect.cwl_2"
        },
        {
            "class": "CommandLineTool",
            "label": "Normalize variants",
            "baseCommand": [
                "/usr/bin/java",
                "-Xmx8g",
                "-jar",
                "/opt/GenomeAnalysisTK.jar",
                "-T",
                "LeftAlignAndTrimVariants"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 9000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/gatk-cwl:3.6.0"
                }
            ],
            "arguments": [
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/normalized.vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-R",
                        "position": 1
                    },
                    "id": "#normalize_variants.cwl/reference"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant",
                        "position": 2
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#normalize_variants.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "outputBinding": {
                        "glob": "normalized.vcf.gz"
                    },
                    "id": "#normalize_variants.cwl/normalized_vcf"
                }
            ],
            "id": "#normalize_variants.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "pindel v0.2.5b8",
            "arguments": [
                "/usr/bin/perl",
                "/usr/bin/pindel_helper.pl",
                "$(inputs.normal_bam.path)",
                "$(inputs.tumor_bam.path)",
                "$(inputs.insert_size)"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 64000,
                    "tmpdirMin": 100000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "inputs": [
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-c",
                        "position": 2
                    },
                    "id": "#pindel.cwl_2/chromosome"
                },
                {
                    "type": "int",
                    "default": 400,
                    "id": "#pindel.cwl_2/insert_size"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#pindel.cwl_2/normal_bam"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-f",
                        "position": 1
                    },
                    "id": "#pindel.cwl_2/reference"
                },
                {
                    "type": "File",
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#pindel.cwl_2/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "all_D"
                    },
                    "id": "#pindel.cwl_2/deletions"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "all_SI"
                    },
                    "id": "#pindel.cwl_2/insertions"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "all_INV"
                    },
                    "id": "#pindel.cwl_2/inversions"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "all_LI"
                    },
                    "id": "#pindel.cwl_2/long_insertions"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "all_TD"
                    },
                    "id": "#pindel.cwl_2/tandems"
                }
            ],
            "id": "#pindel.cwl_2"
        },
        {
            "class": "CommandLineTool",
            "label": "pindel somatic filter v1",
            "arguments": [
                "/usr/bin/perl",
                "/usr/bin/write_pindel_filter_config.pl",
                "$(inputs.pindel_output_summary.path)",
                "$(inputs.reference)",
                "$(runtime.outdir)",
                {
                    "valueFrom": " && ",
                    "shellQuote": false
                },
                "/usr/bin/perl",
                "/usr/bin/somatic_indelfilter.pl",
                "filter.config"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 16000
                },
                {
                    "class": "ShellCommandRequirement"
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "id": "#pindel_somatic_filter.cwl/pindel_output_summary"
                },
                {
                    "type": "string",
                    "id": "#pindel_somatic_filter.cwl/reference"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "pindel.out.vcf"
                    },
                    "id": "#pindel_somatic_filter.cwl/vcf"
                }
            ],
            "id": "#pindel_somatic_filter.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "remove END INFO tags",
            "baseCommand": [
                "/opt/bcftools/bin/bcftools",
                "annotate"
            ],
            "arguments": [
                "-x",
                "INFO/END",
                "-Oz",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/pindel.noend.vcf.gz"
                }
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#remove_end_tags.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "pindel.noend.vcf.gz"
                    },
                    "id": "#remove_end_tags.cwl/processed_vcf"
                }
            ],
            "id": "#remove_end_tags.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "SelectVariants (GATK 3.6)",
            "baseCommand": [
                "/usr/bin/java",
                "-Xmx4g",
                "-jar",
                "/opt/GenomeAnalysisTK.jar",
                "-T",
                "SelectVariants"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 6000,
                    "tmpdirMin": 25000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/gatk-cwl:3.6.0"
                }
            ],
            "arguments": [
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/$(inputs.output_vcf_basename).vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "boolean"
                    ],
                    "inputBinding": {
                        "prefix": "--excludeFiltered",
                        "position": 4
                    },
                    "id": "#select_variants.cwl/exclude_filtered"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "-L",
                        "position": 3
                    },
                    "id": "#select_variants.cwl/interval_list"
                },
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "default": "select_variants",
                    "id": "#select_variants.cwl/output_vcf_basename"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-R",
                        "position": 1
                    },
                    "id": "#select_variants.cwl/reference"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant",
                        "position": 2
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#select_variants.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "outputBinding": {
                        "glob": "$(inputs.output_vcf_basename).vcf.gz"
                    },
                    "id": "#select_variants.cwl/filtered_vcf"
                }
            ],
            "id": "#select_variants.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "create filtered VCF",
            "baseCommand": [
                "/usr/bin/java",
                "-Xmx4g",
                "-jar",
                "/opt/GenomeAnalysisTK.jar",
                "-T",
                "VariantFiltration"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 6000,
                    "tmpdirMin": 25000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "arguments": [
                "--maskName",
                "processSomatic",
                "--filterNotInMask",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/output.vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--mask",
                        "position": 3
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#set_filter_status.cwl/filtered_vcf"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-R",
                        "position": 1
                    },
                    "id": "#set_filter_status.cwl/reference"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant",
                        "position": 2
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#set_filter_status.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "output.vcf.gz"
                    },
                    "id": "#set_filter_status.cwl/merged_vcf"
                }
            ],
            "id": "#set_filter_status.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "docm filter",
            "baseCommand": [
                "/usr/bin/perl",
                "/usr/bin/docm_filter.pl"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                "$(inputs.docm_out.path)",
                "$(inputs.normal_bam.path)",
                "$(inputs.tumor_bam.path)",
                "$(runtime.outdir)"
            ],
            "inputs": [
                {
                    "type": "File",
                    "id": "#somatic_docm_filter.cwl/docm_out"
                },
                {
                    "type": "File",
                    "id": "#somatic_docm_filter.cwl/normal_bam"
                },
                {
                    "type": "File",
                    "id": "#somatic_docm_filter.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "docm_filter_out.vcf"
                    },
                    "id": "#somatic_docm_filter.cwl/docm_filter_out"
                }
            ],
            "id": "#somatic_docm_filter.cwl"
        },
        {
            "class": "CommandLineTool",
            "baseCommand": [
                "/usr/bin/perl",
                "/usr/bin/split_interval_list_helper.pl"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 6000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "arguments": [
                {
                    "valueFrom": "OUTPUT=$(runtime.outdir)"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "INPUT=",
                        "separate": false,
                        "position": 1
                    },
                    "id": "#split_interval_list.cwl/interval_list"
                },
                {
                    "type": "int",
                    "inputBinding": {
                        "prefix": "SCATTER_COUNT=",
                        "separate": false,
                        "position": 2
                    },
                    "id": "#split_interval_list.cwl/scatter_count"
                }
            ],
            "outputs": [
                {
                    "type": {
                        "type": "array",
                        "items": "File"
                    },
                    "outputBinding": {
                        "glob": "*.interval_list"
                    },
                    "id": "#split_interval_list.cwl/split_interval_lists"
                }
            ],
            "id": "#split_interval_list.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "strelka 2.9.9",
            "baseCommand": [
                "/usr/bin/perl",
                "/usr/bin/docker_helper.pl"
            ],
            "requirements": [
                {
                    "dockerPull": "mgibio/strelka-cwl:2.9.9",
                    "class": "DockerRequirement"
                },
                {
                    "coresMin": 4,
                    "ramMin": 4000,
                    "class": "ResourceRequirement"
                }
            ],
            "arguments": [
                {
                    "valueFrom": "$(inputs.cpu_reserved)",
                    "position": 1
                },
                {
                    "valueFrom": "$(runtime.outdir)",
                    "position": 2
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "id": "#strelka.cwl/cpu_reserved"
                },
                {
                    "type": "boolean",
                    "inputBinding": {
                        "prefix": "--exome",
                        "position": 6
                    },
                    "id": "#strelka.cwl/exome_mode"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--normalBam=",
                        "separate": false,
                        "position": 4
                    },
                    "secondaryFiles": [
                        ".bai",
                        "^.bai"
                    ],
                    "id": "#strelka.cwl/normal_bam"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "--referenceFasta=",
                        "separate": false,
                        "position": 5
                    },
                    "id": "#strelka.cwl/reference"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--tumorBam=",
                        "separate": false,
                        "position": 3
                    },
                    "secondaryFiles": [
                        ".bai",
                        "^.bai"
                    ],
                    "id": "#strelka.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "results/variants/somatic.indels.vcf.gz"
                    },
                    "id": "#strelka.cwl/indels"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "results/variants/somatic.snvs.vcf.gz"
                    },
                    "id": "#strelka.cwl/snvs"
                }
            ],
            "id": "#strelka.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "SelectVariants (GATK 3.6)",
            "baseCommand": [
                "/usr/bin/java",
                "-Xmx4g",
                "-jar",
                "/opt/GenomeAnalysisTK.jar",
                "-T",
                "VariantsToTable"
            ],
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 6000,
                    "tmpdirMin": 25000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/gatk-cwl:3.6.0"
                }
            ],
            "arguments": [
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/variants.tsv"
                }
            ],
            "inputs": [
                {
                    "type": {
                        "type": "array",
                        "items": "string",
                        "inputBinding": {
                            "prefix": "-F"
                        }
                    },
                    "default": [
                        "CHROM",
                        "POS",
                        "ID",
                        "REF",
                        "ALT",
                        "set"
                    ],
                    "inputBinding": {
                        "position": 3
                    },
                    "id": "#variants_to_table.cwl/fields"
                },
                {
                    "type": {
                        "type": "array",
                        "items": "string",
                        "inputBinding": {
                            "prefix": "-GF"
                        }
                    },
                    "default": [
                        "GT",
                        "AD",
                        "DP",
                        "AF"
                    ],
                    "inputBinding": {
                        "position": 4
                    },
                    "id": "#variants_to_table.cwl/genotype_fields"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "-R",
                        "position": 1
                    },
                    "id": "#variants_to_table.cwl/reference"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "--variant",
                        "position": 2
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#variants_to_table.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "variants.tsv"
                    },
                    "id": "#variants_to_table.cwl/variants_tsv"
                }
            ],
            "id": "#variants_to_table.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "varscan v2.4.2 processSomatic",
            "arguments": [
                "cp",
                "$(inputs.variants.path)",
                "$(runtime.outdir)/$(inputs.variants.basename)",
                {
                    "valueFrom": " && ",
                    "shellQuote": false
                },
                "java",
                "-jar",
                "/opt/varscan/VarScan.jar",
                "processSomatic"
            ],
            "requirements": [
                {
                    "class": "ShellCommandRequirement"
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "inputBinding": {
                        "prefix": "--max-normal-freq",
                        "position": 2
                    },
                    "id": "#varscan_process_somatic.cwl/max_normal_freq"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "valueFrom": "$(runtime.outdir)/$(self.basename)",
                        "position": 1
                    },
                    "id": "#varscan_process_somatic.cwl/variants"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "*.Germline.vcf"
                    },
                    "id": "#varscan_process_somatic.cwl/germline"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "*.Germline.hc.vcf"
                    },
                    "id": "#varscan_process_somatic.cwl/germline_hc"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "*.LOH.vcf"
                    },
                    "id": "#varscan_process_somatic.cwl/loh"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "*.LOH.hc.vcf"
                    },
                    "id": "#varscan_process_somatic.cwl/loh_hc"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "*.Somatic.vcf"
                    },
                    "id": "#varscan_process_somatic.cwl/somatic"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "*.Somatic.hc.vcf"
                    },
                    "id": "#varscan_process_somatic.cwl/somatic_hc"
                }
            ],
            "id": "#varscan_process_somatic.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "varscan v2.4.2 somatic",
            "baseCommand": "/usr/bin/varscan_helper.sh",
            "requirements": [
                {
                    "class": "ResourceRequirement",
                    "ramMin": 12000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/cle:v1.3.1"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 8,
                    "inputBinding": {
                        "position": 5
                    },
                    "id": "#varscan_somatic.cwl/min_coverage"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.1,
                    "inputBinding": {
                        "position": 6
                    },
                    "id": "#varscan_somatic.cwl/min_var_freq"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 2
                    },
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#varscan_somatic.cwl/normal_bam"
                },
                {
                    "type": [
                        "null",
                        "float"
                    ],
                    "default": 0.99,
                    "inputBinding": {
                        "position": 7
                    },
                    "id": "#varscan_somatic.cwl/p_value"
                },
                {
                    "type": "string",
                    "inputBinding": {
                        "position": 3
                    },
                    "id": "#varscan_somatic.cwl/reference"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "position": 8
                    },
                    "id": "#varscan_somatic.cwl/roi_bed"
                },
                {
                    "type": [
                        "null",
                        "int"
                    ],
                    "default": 0,
                    "inputBinding": {
                        "position": 4
                    },
                    "id": "#varscan_somatic.cwl/strand_filter"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "secondaryFiles": [
                        "^.bai"
                    ],
                    "id": "#varscan_somatic.cwl/tumor_bam"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "output.indel.vcf"
                    },
                    "id": "#varscan_somatic.cwl/indels"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "output.snp.vcf"
                    },
                    "id": "#varscan_somatic.cwl/snvs"
                }
            ],
            "id": "#varscan_somatic.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "add bam_readcount info to vcf",
            "baseCommand": [
                "vcf-readcount-annotator"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "griffithlab/vatools:3.0.1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/annotated.bam_readcount.vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 2
                    },
                    "id": "#vcf_readcount_annotator.cwl_2/bam_readcount_tsv"
                },
                {
                    "type": [
                        {
                            "type": "enum",
                            "symbols": [
                                "#vcf_readcount_annotator.cwl_2/data_type/DNA",
                                "#vcf_readcount_annotator.cwl_2/data_type/RNA"
                            ]
                        }
                    ],
                    "inputBinding": {
                        "position": 3
                    },
                    "id": "#vcf_readcount_annotator.cwl_2/data_type"
                },
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "inputBinding": {
                        "prefix": "-s"
                    },
                    "id": "#vcf_readcount_annotator.cwl_2/sample_name"
                },
                {
                    "type": [
                        "null",
                        {
                            "type": "enum",
                            "symbols": [
                                "#vcf_readcount_annotator.cwl_2/variant_type/snv",
                                "#vcf_readcount_annotator.cwl_2/variant_type/indel",
                                "#vcf_readcount_annotator.cwl_2/variant_type/all"
                            ]
                        }
                    ],
                    "inputBinding": {
                        "prefix": "-t"
                    },
                    "id": "#vcf_readcount_annotator.cwl_2/variant_type"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#vcf_readcount_annotator.cwl_2/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "annotated.bam_readcount.vcf.gz"
                    },
                    "id": "#vcf_readcount_annotator.cwl_2/annotated_bam_readcount_vcf"
                }
            ],
            "id": "#vcf_readcount_annotator.cwl_2"
        },
        {
            "class": "CommandLineTool",
            "label": "Ensembl Variant Effect Predictor",
            "baseCommand": [
                "/usr/bin/perl",
                "-I",
                "/opt/lib/perl/VEP/Plugins",
                "/usr/bin/variant_effect_predictor.pl"
            ],
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                },
                {
                    "class": "ResourceRequirement",
                    "coresMin": 4,
                    "ramMin": 64000,
                    "tmpdirMin": 25000
                },
                {
                    "class": "DockerRequirement",
                    "dockerPull": "mgibio/vep_helper-cwl:1.0.0"
                }
            ],
            "arguments": [
                "--format",
                "vcf",
                "--vcf",
                "--fork",
                "4",
                "--plugin",
                "Downstream",
                "--plugin",
                "Wildtype",
                "--term",
                "SO",
                "--transcript_version",
                "--offline",
                "--cache",
                "--everything",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/annotated.vcf"
                }
            ],
            "inputs": [
                {
                    "type": "string",
                    "inputBinding": {
                        "prefix": "--dir",
                        "position": 4
                    },
                    "id": "#vep.cwl/cache_dir"
                },
                {
                    "type": "boolean",
                    "inputBinding": {
                        "prefix": "--coding_only",
                        "position": 3
                    },
                    "default": false,
                    "id": "#vep.cwl/coding_only"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "inputBinding": {
                        "valueFrom": "${\n    if (inputs.custom_clinvar_vcf) {\n        return [\"--custom\", inputs.custom_clinvar_vcf.path + \",clinvar,vcf,exact,0,CLINSIGN,PHENOTYPE,SCORE,RCVACC,TESTEDINGTR,PHENOTYPELIST,NUMSUBMIT,GUIDELINES\"]\n\n    }\n    else {\n        return []\n    }\n}\n",
                        "position": 7
                    },
                    "id": "#vep.cwl/custom_clinvar_vcf"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "inputBinding": {
                        "valueFrom": "${\n    if (inputs.custom_gnomad_vcf) {\n        return ['--check_existing', '--custom', inputs.custom_gnomad_vcf.path + ',gnomADe,vcf,exact,0,AF,AF_AFR,AF_AMR,AF_ASJ,AF_EAS,AF_FIN,AF_NFE,AF_OTH,AF_SAS']\n    }\n    else {\n        return []\n    }\n}\n",
                        "position": 6
                    },
                    "id": "#vep.cwl/custom_gnomad_vcf"
                },
                {
                    "type": [
                        "null",
                        {
                            "type": "enum",
                            "symbols": [
                                "#vep.cwl/pick/pick",
                                "#vep.cwl/pick/flag_pick",
                                "#vep.cwl/pick/pick_allele",
                                "#vep.cwl/pick/per_gene",
                                "#vep.cwl/pick/pick_allele_gene",
                                "#vep.cwl/pick/flag_pick_allele",
                                "#vep.cwl/pick/flag_pick_allele_gene"
                            ]
                        }
                    ],
                    "default": "flag_pick",
                    "inputBinding": {
                        "prefix": "--",
                        "separate": false,
                        "position": 7
                    },
                    "id": "#vep.cwl/pick"
                },
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "inputBinding": {
                        "prefix": "--fasta",
                        "position": 8
                    },
                    "id": "#vep.cwl/reference"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "inputBinding": {
                        "prefix": "--synonyms",
                        "position": 2
                    },
                    "id": "#vep.cwl/synonyms_file"
                },
                {
                    "type": "File",
                    "inputBinding": {
                        "prefix": "-i",
                        "position": 1
                    },
                    "id": "#vep.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "annotated.vcf"
                    },
                    "id": "#vep.cwl/annotated_vcf"
                },
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "annotated.vcf_summary.html"
                    },
                    "id": "#vep.cwl/vep_summary"
                }
            ],
            "id": "#vep.cwl"
        },
        {
            "class": "CommandLineTool",
            "label": "run vt decompose",
            "baseCommand": [
                "vt",
                "decompose"
            ],
            "requirements": [
                {
                    "class": "DockerRequirement",
                    "dockerPull": "quay.io/biocontainers/vt:0.57721--hf74b74d_1"
                },
                {
                    "class": "ResourceRequirement",
                    "ramMin": 4000
                }
            ],
            "arguments": [
                "-s",
                "-o",
                {
                    "valueFrom": "$(runtime.outdir)/decomposed.vcf.gz"
                }
            ],
            "inputs": [
                {
                    "type": "File",
                    "inputBinding": {
                        "position": 1
                    },
                    "secondaryFiles": [
                        ".tbi"
                    ],
                    "id": "#vt_decompose.cwl/vcf"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "outputBinding": {
                        "glob": "decomposed.vcf.gz"
                    },
                    "id": "#vt_decompose.cwl/decomposed_vcf"
                }
            ],
            "id": "#vt_decompose.cwl"
        }
    ],
    "cwlVersion": "v1.0"
}
